'use strict';

/* --------------------------------------------------------------
 datatable_fixed_row_actions.js 2016-07-13
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2016 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

/**
 * ## Enable fixed table row actions that do not hide on mouse leave.
 *
 * By default the actions will be hidden when on mouse leave event. This module will make sure that they
 * stay visible.
 *
 * @module Admin/Extensions/datatable_fixed_row_actions
 */
gx.extensions.module('datatable_fixed_row_actions', [], function (data) {

    'use strict';

    // ------------------------------------------------------------------------
    // VARIABLES
    // ------------------------------------------------------------------------

    /**
     * Module Selector
     *
     * @type {jQuery}
     */

    var $this = $(this);

    /**
     * Module Instance
     *
     * @type {Object}
     */
    var module = {};

    // ------------------------------------------------------------------------
    // FUNCTIONS
    // ------------------------------------------------------------------------

    /**
     * On Table Row Mouse Leave
     *
     * The dropdown must remain visible if it was open when the cursor leaves the table row.
     */
    function _onTableRowMouseLeave() {
        var visibility = $(this).find('.btn-group.dropdown').hasClass('open') ? 'visible' : '';
        $(this).find('.actions .visible-on-hover').css('visibility', visibility);
    }

    /**
     * On Bootstrap Dropdown Menu Toggle
     *
     * Remove any custom visibility set by this module whenever the user interacts with a dropdown toggle.
     */
    function _onBootstrapDropdownToggle() {
        $this.find('.actions .visible-on-hover').css('visibility', '');
    }

    // ------------------------------------------------------------------------
    // INITIALIZATION
    // ------------------------------------------------------------------------

    module.init = function (done) {
        $this.on('mouseleave', 'tr', _onTableRowMouseLeave).on('shown.bs.dropdown hidden.bs.dropdown', _onBootstrapDropdownToggle);

        done();
    };

    return module;
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
